# -*- coding: utf-8 -*-
from Products.CMFCore.utils import getToolByName
from five import grok
from period import IPeriod
from plone.app.textfield import RichText
from plone.directives import form
from plone.formwidget.contenttree import ObjPathSourceBinder
from plone.memoize.instance import memoize
from plone.uuid.interfaces import IUUID
from venue import IVenue
from wasgehtengine.contenttypes import WasgehtengineMessageFactory as _
from z3c.form import validator
from z3c.relationfield.schema import RelationList, RelationChoice, RelationList, \
    RelationChoice, Relation
from zope import schema
from zope.component import getMultiAdapter
from zope.interface import Invalid
from Products.CMFDefault.interfaces import INewsItem
from DateTime import DateTime
from datetime import timedelta
from datetime import datetime
from zope.interface import Interface
import iso8601

class BlogItemView(grok.View):

    grok.context(Interface)
    grok.require('zope2.View')
    grok.name('blog_item')
    
    def update(self):
        pass
            
    def creator(self):
        return self.context.Creator()

    def author(self):
        membership = getToolByName(self.context, 'portal_membership')
        return membership.getMemberInfo(self.creator())

    def authorname(self):
        author = self.author()
        return author and author['fullname'] or self.creator()
    
    def toLocalizedTime(self, time, long_format=None, time_only = None):
        """Convert time to localized time
        """
        util = getToolByName(self.context, 'translation_service')
        return util.ulocalized_time(time, long_format, time_only, self.context,
                                    domain='plonelocales')