"""test module for the timestamp manipulation
"""
from pki.utils import datetime_to_timestamp, timestamp_to_datetime
from pki.utils import plus_twentyyears
import datetime

def test_datetime_to_timestamp():
    testdatetime = datetime.datetime(1976, 5, 5)
    result = datetime_to_timestamp(testdatetime)

    assert result == 200102400

def test_timestamp_to_datetime():
    stamp = 200102400
    result = timestamp_to_datetime(stamp)

    assert result == datetime.datetime(1976, 5, 5)

def test_plus_twentyyears():
    testtime = datetime.datetime(2015, 11, 23, 15, 22, 34, 504)
    twentymore = plus_twentyyears(testtime)

    assert twentymore == datetime.datetime(2035, 11, 23, 15, 22, 34, 504)
    
