"""utility functions
"""

import datetime
import os
import tempfile

epoch = datetime.datetime(1970, 1, 1, 0, 0, 0)

def plus_twentyyears(dt):
    """helper function to return a datetime with some 20 years added to it
    """
    return datetime.datetime(dt.year+20, dt.month, dt.day,
            dt.hour, dt.minute, dt.second, dt.microsecond)

def datetime_to_timestamp(dt):
    """this function takes a datetime.datetime instance as parameter
    and returns an integer representing the number for seconds
    since the 1st of january 1970 (epoch).

    WARNING: OpenSSL considers the epoch to be 1/1/1970 and thus
    this function does the same. Do not try to use this function
    with datetimes that are older than this date.
    """
    delta = dt - epoch

    return delta.days * 24 * 3600 + delta.seconds

def timestamp_to_datetime(ts):
    """this function takes a timestamp expressed with 1/1/1970 as the
    epoch and returns a python datetime.datetime instance
    """
    delta = datetime.timedelta(0, ts)

    return epoch + delta


def get_secure_filename():
    """Creates a tempfile in the most secure manner possible,
    make sure is it closed and return the filename for
    easy usage.
    """

    file_handle, filename = tempfile.mkstemp()
    tmpfile = os.fdopen(file_handle, "r")
    tmpfile.close()
    return filename


