##*DxfStructure Concrete help*

---
###*Available functions*

|Name|Description|
|-------|----------|
|`(1)Concrete Check`| Checks the drawing|
|`(2)Concrete Check and save`| Checks the drawing and draws warnings in modelspace on `DS_TMPCHECK` layer|
|`(3)Concrete Show dependencies and save`| Shows bar annotation dependencies and draws them as line in modelspace on `DS_TMPCHECK` layer
|`(4)Concrete Process data and save`| Updates quantities and marks of bars|
|`(5)check for quite similare bar no.`| It checks does there are bars that have quite similar shape (but are not identical) and was not marked with the same number|
|`(6)Concrete Process data with renumerate and save`| Updates quantities and marks of bars and renumerates bars|
|`(7)Concrete Process data with renumerate, schedules and save`| Updates quantities and marks of bars and renumerates bars then draws bar schedule in modelspace|
|`(8)Concrete Help`| Displays help for concrete|
---
###*Layer system used for concrete drawing *

|Name|Description|
|-------|----------|
|`DS_CBAR`|Bar shape pline definition|
|`DS_CTEXT`| Bar annotation|
|`DS_DEPLINE`|Definition of annotation dependency|
|`DS_ELEMENT`|Definition of element area in model space|
|`DS_RANGE`|Bar arrangement definition|
|`DS_SCHEDULE`|Used to create bar schedule|
|`DS_TMPCHECK`|Temporary layer for warning|

---
###*Bar annotation syntax*

|`5`|`#`|`12`|-|[|`10`|]|-|`200`|`T`|
|-|-|-|-|-|-|-|-|-|-|
|Number|Type|Size|-|[|Mark|]|-|Centre|Location|

|Legend:| |
|-------|----------|
|Number|- number of bars (1,2,4,5.. or expression with +/-/* )|
|Type|- steel type symbol (# - B500A)|
|Size|- standard bar diameter in [mm] (6,8,12,14,16 ...)|
|Mark|- bar mark (auto generated by program)|
|Centre|- bar space inside arrangement in [mm] (100, 200, 250 ...) |
|Location|- bar location symbol (T-top, B-bottom, TB - top and bottom etc.)|

At last Type, Size and Mark must be specifed.

|Example:|(total number)|
|---|---|---|
|15#10-[3]-200ZW|(30)|
|15#10-[3]-200Z|(15)|
|15#10-[3]-200|(15)|
|15#10-[3]|(15)|
|15#10-[3]-Z|(15)|
|15#10-[3]-ZW|(30)|
|1#10-[3]|(1)|
|#10-[3]|(0)|
|2+2#10-[3]-200|(4)|
|2+2#10-[3]-200ZW|(8)|
|2*3#10-[3]-200|(6)|
|2*3#10-[3]-200ZW|(12)|
|etc.|sd|
---
###*Bar annotation special colours*
|Color|meaning|
|-------|----------|
|`5(blue) or 140`|- it does not stick to the bar peline, countable|
|`7(white) or 254`|- it does not stick to the bar peline, uncountable|
|`33`|- full active - bar specifed in meter length in schedule|
|any other|- full active - bar specifed with it shape in schedule|

Use color `5 or 140` and `7 or 254` to create depended bar annotation.

Use colour `33` for bars that should be deliver on site as standard straight lenght bar (12m) and then cut and bend as need.

---
###*Bar pline (on layer `DS_CBAR`) special colours*
|Color| |
|-------|----------|
|55|- dead bar pline|
|200|- full active bar with forced straight shape in schedule|
|any other|- full active bar pline|

Use colour `55` to draw inactive bar illustration in drawing.

Use colour `200` to draw high radius curved bars that should be deliver on site as straight.

---
###*Element description syntax*

|`Element`|`_`|`Wall`|`_`|`x`|`_`|`5`|
|-|-|-|-|-|-|-|-|-|-|
|||Element name||||Number|

Please not that 'Element' prefix is not needed.

|Example:||
|---||
|Element Bk-1 x 5||
|Element Slup x 5||
|Slup x 5||
|Beam-1 x 5||

---
##*Use case*
---
##*(1) - annotated bar*
![](help_concrete_usecase_1.png)
---
##*(2) - annotated bar with ref pline*
![](help_concrete_usecase_2.png)
---
##*(3) - annotated bar with dependence annotations*
![](help_concrete_usecase_3.png)
---
##*(4) - annotated bar with arrangement*
![](help_concrete_usecase_4.png)
---
##*(5) - element definition*
![](help_concrete_usecase_5.png)
---
##*(6) - bars specifed in meter length*
![](help_concrete_usecase_6.png)
---
##*(7) - bars specifed in meter length with no pline*
![](help_concrete_usecase_7.png)
---
##*(8)auto generated schedule for 1 - 5 use case in use_case.dxf*
![](help_concrete_usecase_schedule.png)

Please find `use_case.dxf` in `../dxfstructure/example` folder. There are a few example dxf files in the same folder too.